local TNSNames = {
	THEME:GetString("TapNoteScore","W1"),
	THEME:GetString("TapNoteScore","W2"),
	THEME:GetString("TapNoteScore","W3"),
	THEME:GetString("TapNoteScore","W4"),
	THEME:GetString("TapNoteScore","W5"),
	THEME:GetString("TapNoteScore","Miss"),
	"Holds",
	"Max Combo"
};

-- JudgeLabels()
-- Print all the boring labels.
local function JudgeLabels()
	local l = Def.ActorFrame{};

	for i=1,#TNSNames do
		l[#l+1] = AutoText("frutiger")..{
			InitCommand=cmd(shadowlength,1;NoStroke;zoom,0.833);
			BeginCommand=function(self)
				self:y((i-1)*24);
				self:settext(TNSNames[i]);
				if i < 6 then -- W1-W5
					self:diffuse( JudgeColor('TapNoteScore_W'..i) );
				elseif i == 6 then -- Miss
					self:diffuse( JudgeColor('TapNoteScore_Miss') );
				elseif i == 7 then -- holds
					self:diffuse( JudgeColor('TapNoteScore_W1') );
				elseif i == 8 then -- max combo
					self:diffuse( PlayerColor(PLAYER_1) );
				end;
			end;
		};
	end;

	return l;
end;

local t = Def.ActorFrame{
	-- background
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_eval", 244,282 )..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+55);
	};
	-- separator
	Def.Quad{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-40;zoomto,250,4;diffuse,color("#000000");fadeleft,0.25;faderight,0.25);
	};
	-- labels
	JudgeLabels()..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-24);
	};
};

return t;